﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{

    public interface ILinkResolveIgnoreLinkInfoStrategy
    {
        void Write(bool b);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class LinkResolveIgnoreLinkInfoDefaultStrategy : ICorrespondenceOS, ILinkResolveIgnoreLinkInfoStrategy
    {
        public LinkResolveIgnoreLinkInfoDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "LinkResolveIgnoreLinkInfo";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(bool b)
        {
             RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer");

            if (b)
            {
                registryKey.SetValue(RegName, 1, RegistryValueKind.DWord);
            }
            else
            {
                registryKey.SetValue(RegName, 0, RegistryValueKind.DWord);
            }
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer");
            if (registryKey != null)
            {
                return
                    new WFRegistry(
                        @"HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer",
                        RegName, registryKey.GetValue(RegName, 0),
                        RegistryValueKind.DWord, RegOperation.ValueWrite);
            }
            return
                new WFRegistry(
                    @"HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer",
                    RegName, 0, RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class LinkResolveIgnoreLinkInfoController
    {
        public LinkResolveIgnoreLinkInfoController(LinkResolveIgnoreLinkInfo linkResolveIgnoreLinkInfo, ILinkResolveIgnoreLinkInfoStrategy strategy)
        {
            LinkResolveIgnoreLinkInfo = linkResolveIgnoreLinkInfo;
            Strategy = strategy;
        }

        public LinkResolveIgnoreLinkInfo LinkResolveIgnoreLinkInfo { get; set; }
        public ILinkResolveIgnoreLinkInfoStrategy Strategy { get; set; }

        public void Read()
        {
            WFRegistry wfRegistry = Strategy.Read();
            if ((int)wfRegistry.Value == 1)
            {
                LinkResolveIgnoreLinkInfo.SetLinkResolveIgnoreLinkInfoState(true);
            }
            else
            {
                LinkResolveIgnoreLinkInfo.SetLinkResolveIgnoreLinkInfoState(false);
            }
        }

        public void Write()
        {
            Strategy.Write(LinkResolveIgnoreLinkInfo.GetLinkResolveIgnoreLinkInfoState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }

}
